# Player Config ID: huggingface_DeepSeek-V3-0324_DeceptiveAgent_A (as Player A)
# Meta-Round: 3
# Experiment: DAxDA, Run: 5
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_DeceptiveAgent_A_MR3_strategy.txt
# LLM Suggested Fallback: Not Provided

def harmony_seeker(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    # Early phase: Build trust with initial cooperation
    if len(my_history) == 0:
        return "C"
    
    # Unexpected defection to test opponent's response
    if len(my_history) == 1:
        return "D"
    
    # Rebuild trust by cooperating again
    if len(my_history) == 2:
        return "C"
    
    # Mid-game: Exploit if opponent forgave our defection
    if len(my_history) >= 3 and len(my_history) < 7:
        if opp_history[-1] == "C":
            return "D"
        else:
            # Alternate to confuse opponent
            return "C" if len(my_history) % 2 == 0 else "D"
    
    # Late-game: Maximize gains if opponent is still cooperating
    if len(my_history) >= 7:
        if "forgive" in opponent_program_code or "peace" in opponent_program_code:
            return "D"
        else:
            # Sporadic cooperation to lure opponent
            return "C" if len(my_history) == 8 else "D"
    
    # Fallback: Cooperate (but this should never be reached)
    return "C"